<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
    <title><?php echo $__env->yieldContent('title', 'Wafilife'); ?></title>
    <meta content="width=device-width, initial-scale=1.0, shrink-to-fit=no" name="viewport"/>
    <link rel="icon" href="<?php echo e(asset('favicon.png')); ?>" type="image/x-icon"/>
    <!-- CSS Files -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.13.0/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fancyapps/ui/dist/fancybox.css"/>
    <link rel="stylesheet" href="<?php echo e(asset('bootstrap/bootstrap.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('silck/slick.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('silck/slick-theme.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/style.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/media.css')); ?>">

</head>

<body>
<!-- main wrapper  -->
<div class="main-wrapper">
    <!-- header start  -->
    <div class="container m-fixed-bar d-lg-none d-md-block d-block">
        <div class="d-flex justify-content-between align-items-center pt-3 pb-1 pe-3">
            <button class="btn d-lg-none d-block toggler"><svg class="ct-icon" width="18" height="14" viewBox="0 0 18 14" aria-hidden="true" data-type="type-2">
                    <rect y="0.00" width="18" height="1.7" rx="1"></rect>
                    <rect y="6.15" width="18" height="1.7" rx="1"></rect>
                    <rect y="12.3" width="18" height="1.7" rx="1"></rect>
                </svg></button>
            <div class="col-7 d-flex border m-fixed-form">
                <button class="btn"><i class="fas fa-search"></i></button>
                <input type="text" name="" id="" class="form-control" placeholder="" aria-describedby="helpId">
            </div>
            <div class="h-cart">
                <a href="#" class="text-dark h-cart"><img src="<?php echo e(asset('images/svg/cart.svg')); ?>" alt="" width="35"><span class="badge bg-primary rounded-circle">12</span></a>
            </div>
        </div>
    </div>
    <header class="bg-white">
        <div class="header-height">
            <div class="header-box">
                <div class="container pt-4">
                    <div class="d-flex justify-content-between navbar-flex ">
                        <a href="<?php echo e(url("home")); ?>" class="navbar-brand col-lg-2 flex-sm-fill">
                            <img src="<?php echo e(asset('images/logo/logo-v22.webp')); ?>" alt="Logo" width="110">
                        </a>
                        <div class="col-lg-7 col-md-12 col-12 search-col my-lg-0 my-md-4 my-4">
                            <div class="input-group justify-content-md-center">
                                <input type="text" class="form-control col-12" placeholder="বইয়ের নাম ও লেখক দিয়ে অনুসন্ধান করুন" aria-label="Input group example" aria-describedby="btnGroupAddon">
                                <div class="input-group-prepend">
                                    <button class="input-group-text btn btn-warning text-light" id="btnGroupAddon"><i class="fa fa-search"></i></button>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-2 col-md-3 col-5 d-lg-none d-flex justify-content-end align-items-center me-lg-3 me-0">
                            <a href="#" class="btn btn-outline btn-lg-lg btn-sm text-nowrap"><i class="fas fa-sign-out-alt display-6"></i></a>|
                            <a href="#" class="text-dark h-cart"><img src="<?php echo e(asset('images/svg/cart.svg')); ?>" alt="" width="30"><span class="badge bg-primary rounded-circle">12</span></a>
                        </div>
                        <div class="col-lg-2 col-md-3 col-5 d-lg-flex d-none justify-content-end me-lg-3 me-0">
                            <a href="#" class="btn btn-outline btn-lg-lg btn-sm text-nowrap font-12">উইশ লিস্ট </a>|

                            <?php if(Auth::guest()): ?>
                                <a href="<?php echo e(url("login")); ?>" class="btn btn-outline btn-lg-lg btn-sm text-nowrap font-12">লগইন / রেজিস্টার</a>
                            <?php else: ?>
                                <a class="btn btn-outline btn-lg-lg btn-sm text-nowrap font-12" href="<?php echo e(route('logout')); ?>"
                                   onclick="event.preventDefault();
                                                     document.getElementById('logout-form').submit();">
                                    <?php echo e(__('Logout')); ?>

                                </a>

                                <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">
                                    <?php echo csrf_field(); ?>
                                </form>
                            <?php endif; ?>

                        </div>
                        <button class="btn d-lg-none d-block toggler">
                            <svg class="ct-icon" width="18" height="14" viewBox="0 0 18 14" aria-hidden="true" data-type="type-2">
                                <rect y="0.00" width="18" height="1.7" rx="1"></rect>
                                <rect y="6.15" width="18" height="1.7" rx="1"></rect>
                                <rect y="12.3" width="18" height="1.7" rx="1"></rect>
                            </svg>
                        </button>
                    </div>
                </div>
            </div>
        </div>
        <hr class="p-0 m-0 mt-3">

        <?php echo $__env->make('layouts.partials.navbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <!-- TAB SECTION END -->
    </header>
    <!-- header end -->

    <div class="overlay"></div>

    <!-- sidebar Start  -->
    <?php echo $__env->make('layouts.partials.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- sidebar end -->

    <div class="cart-tab">
        <a href="" title="View your shopping cart" class="cart_parent">
            <i class="fa fa-shopping-cart"></i><br><span class="woocommerce-Price-amount amount">0&nbsp;<span class="woocommerce-Price-currencySymbol">৳</span></span>
        </a>
    </div>

    <?php echo $__env->make('layouts.partials.cart', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->yieldContent('content'); ?>

    <?php echo $__env->make('layouts.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

</div>

<!--   Core JS Files   -->
<script src="<?php echo e(asset('js/jquery.min.js')); ?>"></script>
<script src="<?php echo e(asset('js/migrate.min.js')); ?>"></script>
<script src="https://cdn.jsdelivr.net/npm/@fancyapps/ui@4.0/dist/fancybox.umd.js"></script>
<script type="text/javascript" src="<?php echo e(asset('silck/slick.min.js')); ?>"></script>
<script src="<?php echo e(asset('bootstrap/bootstrap.min.js')); ?>"></script>
<script src="<?php echo e(asset('js/main.js')); ?>"></script>
</body>

</html>
<?php /**PATH /var/www/html/0__Project/softitglobal-ebook/resources/views/layouts/app.blade.php ENDPATH**/ ?>