<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Writer extends Model
{
    use HasFactory;

    protected $fillable = ['name', 'description', 'is_active'];

    /**
     * Get the books associated with the writer.
     */
    public function books()
    {
        return $this->belongsToMany(Book::class, 'book_writer');
    }
}
