<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Book extends Model
{
    use HasFactory;

    protected $fillable = [
        'title',
        'description',
        'image',
        'publisher_id',
        'subject_id',
    ];

    /**
     * Get the publisher associated with the book.
     */
    public function publisher()
    {
        return $this->belongsTo(Publisher::class);
    }

    /**
     * Get the subject associated with the book.
     */
    public function subject()
    {
        return $this->belongsTo(Subject::class);
    }

    /**
     * Get the writers associated with the book.
     */
    public function writers()
    {
        return $this->belongsToMany(Writer::class, 'book_writer');
    }
}
